<?php
// การตั้งค่าฐานข้อมูล
$host = "localhost";
$db_user = "root";
$db_pass = ""; // เปลี่ยนเป็นรหัสผ่านของคุณ
$db_name = "mini_cms_db";

// ตั้งค่า Session ที่ปลอดภัย
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 0); // เปลี่ยนเป็น 1 ถ้าใช้ HTTPS
ini_set('session.cookie_samesite', 'Strict');
ini_set('session.use_strict_mode', 1);

session_start();

try {
    // สร้างการเชื่อมต่อด้วย PDO
    $pdo = new PDO("mysql:host=$host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);

    // ตั้งค่า Error Mode เป็น Exception
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // ตั้งค่าให้ fetch ข้อมูลเป็น Associative Array
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("การเชื่อมต่อล้มเหลว");
}

// ฟังก์ชันช่วยเหลือ
/**
 * @param $data
 */
function sanitize($data)
{
    return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
}

/**
 * @param $url
 */
function redirect($url)
{
    header("Location: $url");
    exit();
}

// ฟังก์ชันสร้าง CSRF Token
/**
 * @return mixed
 */
function generateCsrfToken()
{
    if (empty($_SESSION['csrf_token'])) {
        if (function_exists('random_bytes')) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        } elseif (function_exists('openssl_random_pseudo_bytes')) {
            $_SESSION['csrf_token'] = bin2hex(openssl_random_pseudo_bytes(32));
        } else {
            // Fallback สำหรับ server ที่ไม่รองรับ
            $_SESSION['csrf_token'] = md5(uniqid(mt_rand(), true));
        }
    }
    return $_SESSION['csrf_token'];
}

// ฟังก์ชันตรวจสอบ CSRF Token
/**
 * @param $token
 */
function verifyCsrfToken($token)
{
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// ฟังก์ชัน Security Headers
function setSecurityHeaders()
{
    header('X-Frame-Options: DENY');
    header('X-Content-Type-Options: nosniff');
    header('X-XSS-Protection: 1; mode=block');
    header('Referrer-Policy: strict-origin-when-cross-origin');
}

setSecurityHeaders();
