<?php
include 'config.php';

$message = '';
$message_type = '';
$title = $content = $author = $category = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ตรวจสอบ CSRF Token
    if (!verifyCsrfToken($_POST['csrf_token'] ?? '')) {
        die("CSRF token validation failed");
    }

    $title = sanitize($_POST['title']);
    $content = $_POST['content']; // เก็บ content แบบเต็ม
    $author = sanitize($_POST['author']);
    $category = sanitize($_POST['category']);

    // ตรวจสอบข้อมูล
    if (empty($title) || empty($content)) {
        $message = "กรุณากรอกชื่อบทความและเนื้อหา";
        $message_type = "error";
    } else {
        try {
            // ใช้ PDO Prepared Statement เพื่อความปลอดภัย
            $stmt = $pdo->prepare("INSERT INTO articles (title, content, author, category) VALUES (:title, :content, :author, :category)");

            $stmt->execute([
                'title' => $title,
                'content' => $content,
                'author' => $author,
                'category' => $category
            ]);

            $message = "เพิ่มบทความสำเร็จ!";
            $message_type = "success";
            // ล้างค่าฟอร์ม
            $title = $content = $author = $category = '';

        } catch(PDOException $e) {
            $message = "เกิดข้อผิดพลาด: " . $e->getMessage();
            $message_type = "error";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>เพิ่มบทความใหม่ - Mini CMS</title>
    <link rel="stylesheet" href="styles/main.css">
</head>
<body>
    <div class="container">
        <header class="site-header">
            <h1>📝 เพิ่มบทความใหม่</h1>
        </header>

        <div class="toolbar">
            <a href="index.php" class="button-secondary">← กลับหน้าแรก</a>
        </div>

        <?php if (!empty($message)): ?>
            <div class="message <?php echo $message_type; ?>">
                <?php echo $message; ?>
                <?php if ($message_type == 'success'): ?>
                    <a href="index.php" class="message-link">ดูรายการบทความ</a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="form-container">
            <form action="create.php" method="POST" class="article-form">
                <input type="hidden" name="csrf_token" value="<?php echo generateCsrfToken(); ?>">

                <div class="form-group">
                    <label for="title">ชื่อบทความ <span class="required">*</span></label>
                    <input type="text"
                           id="title"
                           name="title"
                           required
                           maxlength="255"
                           value="<?php echo htmlspecialchars($title); ?>"
                           placeholder="กรอกชื่อบทความ"
                           class="form-input">
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="author">ชื่อผู้เขียน</label>
                        <input type="text"
                               id="author"
                               name="author"
                               maxlength="100"
                               value="<?php echo htmlspecialchars($author); ?>"
                               placeholder="ไม่ระบุชื่อ"
                               class="form-input">
                    </div>

                    <div class="form-group">
                        <label for="category">หมวดหมู่</label>
                        <select id="category" name="category" class="form-select">
                            <option value="ทั่วไป" <?php echo ($category == 'ทั่วไป') ? 'selected' : ''; ?>>ทั่วไป</option>
                            <option value="HTML" <?php echo ($category == 'HTML') ? 'selected' : ''; ?>>HTML</option>
                            <option value="CSS" <?php echo ($category == 'CSS') ? 'selected' : ''; ?>>CSS</option>
                            <option value="JavaScript" <?php echo ($category == 'JavaScript') ? 'selected' : ''; ?>>JavaScript</option>
                            <option value="PHP" <?php echo ($category == 'PHP') ? 'selected' : ''; ?>>PHP</option>
                            <option value="MySQL" <?php echo ($category == 'MySQL') ? 'selected' : ''; ?>>MySQL</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="content">เนื้อหาบทความ <span class="required">*</span></label>
                    <textarea id="content"
                              name="content"
                              rows="15"
                              required
                              placeholder="เขียนเนื้อหาบทความที่นี่..."
                              class="form-textarea"><?php echo htmlspecialchars($content); ?></textarea>
                    <div class="form-hint">รองรับการขึ้นบรรทัดใหม่และย่อหน้า</div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="button-primary">💾 บันทึกบทความ</button>
                    <button type="reset" class="button-secondary">🔄 ล้างฟอร์ม</button>
                </div>
            </form>
        </div>
    </div>

    <script src="scripts/main.js"></script>
</body>
</html>
