<?php
include 'config.php';

// ตรวจสอบ ID และ CSRF Token
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$csrf_token = isset($_GET['csrf_token']) ? $_GET['csrf_token'] : '';

if ($id <= 0) {
    redirect('index.php');
}

// ตรวจสอบ CSRF Token
if (!verifyCsrfToken($csrf_token)) {
    die("CSRF token validation failed");
}

try {
    // ลบบทความ
    $stmt = $pdo->prepare("DELETE FROM articles WHERE id = :id");
    $stmt->execute(['id' => $id]);

    // Redirect กลับไปหน้าแรก
    $_SESSION['message'] = "ลบบทความสำเร็จ";
    $_SESSION['message_type'] = "success";
    redirect('index.php');

} catch (PDOException $e) {
    $_SESSION['message'] = "เกิดข้อผิดพลาด: ".$e->getMessage();
    $_SESSION['message_type'] = "error";
    redirect('index.php');
}
