<?php
include 'config.php';

$message = '';
$message_type = '';
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    redirect('index.php');
}

// ดึงข้อมูลเดิมมาแสดง
$stmt = $pdo->prepare("SELECT title, content, author, category FROM articles WHERE id = :id");
$stmt->execute(['id' => $id]);
$article = $stmt->fetch();

if (!$article) {
    redirect('index.php');
}

// ประมวลผลเมื่อมีการส่งฟอร์มแก้ไข
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ตรวจสอบ CSRF Token
    if (!verifyCsrfToken(isset($_POST['csrf_token']) ? $_POST['csrf_token'] : '')) {
        die("CSRF token validation failed");
    }

    $title = sanitize($_POST['title']);
    $content = $_POST['content'];
    $author = sanitize($_POST['author']);
    $category = sanitize($_POST['category']);

    if (empty($title) || empty($content)) {
        $message = "กรุณากรอกชื่อบทความและเนื้อหา";
        $message_type = "error";
    } else {
        $stmt_update = $pdo->prepare("UPDATE articles SET title = :title, content = :content, author = :author, category = :category WHERE id = :id");

        $stmt_update->execute([
            'title' => $title,
            'content' => $content,
            'author' => $author,
            'category' => $category,
            'id' => $id
        ]);

        $message = "แก้ไขบทความสำเร็จ!";
        $message_type = "success";
        // อัปเดตค่าในตัวแปร $article
        $article['title'] = $title;
        $article['content'] = $content;
        $article['author'] = $author;
        $article['category'] = $category;
    }
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>แก้ไขบทความ - Mini CMS</title>
    <link rel="stylesheet" href="styles/main.css">
</head>
<body>
    <div class="container">
        <header class="site-header">
            <h1>✏️ แก้ไขบทความ</h1>
        </header>

        <div class="toolbar">
            <a href="index.php" class="button-secondary">← กลับหน้าแรก</a>
            <a href="view.php?id=<?php echo $id; ?>" class="button-secondary">👁️ ดูบทความ</a>
        </div>

        <?php if (!empty($message)): ?>
            <div class="message <?php echo $message_type; ?>">
                <?php echo $message; ?>
                <?php if ($message_type == 'success'): ?>
                    <a href="view.php?id=<?php echo $id; ?>" class="message-link">ดูบทความ</a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="form-container">
            <form action="edit.php?id=<?php echo $id; ?>" method="POST" class="article-form">
                <input type="hidden" name="csrf_token" value="<?php echo generateCsrfToken(); ?>">

                <div class="form-group">
                    <label for="title">ชื่อบทความ <span class="required">*</span></label>
                    <input type="text"
                           id="title"
                           name="title"
                           required
                           maxlength="255"
                           value="<?php echo htmlspecialchars($article['title']); ?>"
                           class="form-input">
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="author">ชื่อผู้เขียน</label>
                        <input type="text"
                               id="author"
                               name="author"
                               maxlength="100"
                               value="<?php echo htmlspecialchars($article['author']); ?>"
                               class="form-input">
                    </div>

                    <div class="form-group">
                        <label for="category">หมวดหมู่</label>
                        <select id="category" name="category" class="form-select">
                            <option value="ทั่วไป" <?php echo($article['category'] == 'ทั่วไป') ? 'selected' : ''; ?>>ทั่วไป</option>
                            <option value="HTML" <?php echo($article['category'] == 'HTML') ? 'selected' : ''; ?>>HTML</option>
                            <option value="CSS" <?php echo($article['category'] == 'CSS') ? 'selected' : ''; ?>>CSS</option>
                            <option value="JavaScript" <?php echo($article['category'] == 'JavaScript') ? 'selected' : ''; ?>>JavaScript</option>
                            <option value="PHP" <?php echo($article['category'] == 'PHP') ? 'selected' : ''; ?>>PHP</option>
                            <option value="MySQL" <?php echo($article['category'] == 'MySQL') ? 'selected' : ''; ?>>MySQL</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="content">เนื้อหาบทความ <span class="required">*</span></label>
                    <textarea id="content"
                              name="content"
                              rows="15"
                              required
                              class="form-textarea"><?php echo htmlspecialchars($article['content']); ?></textarea>
                </div>

                <div class="form-actions">
                    <button type="submit" class="button-primary">💾 บันทึกการแก้ไข</button>
                    <a href="view.php?id=<?php echo $id; ?>" class="button-secondary">❌ ยกเลิก</a>
                </div>
            </form>
        </div>
    </div>

    <script src="scripts/main.js"></script>
</body>
</html>
